/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public record WheelBase(List<WheelPos> wheels) {
    public static final Codec<WheelBase> CODEC = Codec.list(WheelPos.CODEC).xmap(WheelBase::new, WheelBase::wheels);
    public static final StreamCodec<RegistryFriendlyByteBuf, WheelBase> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.list().apply(WheelPos.STREAM_CODEC), WheelBase::wheels, WheelBase::new);

    public int wheelCount() {
        return this.wheels().size();
    }

    public static WheelBase basic(float sepLong, float sepWide) {
        return new WheelBase(List.of(new WheelPos(sepLong / 2.0f, sepWide / -2.0f, 1.0f, 0.0f, WheelEnd.FRONT, WheelSide.LEFT), new WheelPos(sepLong / -2.0f, sepWide / -2.0f, 1.0f, 0.0f, WheelEnd.BACK, WheelSide.LEFT), new WheelPos(sepLong / 2.0f, sepWide / 2.0f, 1.0f, 180.0f, WheelEnd.FRONT, WheelSide.RIGHT), new WheelPos(sepLong / -2.0f, sepWide / 2.0f, 1.0f, 180.0f, WheelEnd.BACK, WheelSide.RIGHT)));
    }

    public record WheelPos(float forward, float right, float scale, float yaw, WheelEnd end, WheelSide side) {
        public static final Codec<WheelPos> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("forward").forGetter(WheelPos::forward), (App)Codec.FLOAT.fieldOf("right").forGetter(WheelPos::right), (App)Codec.FLOAT.fieldOf("scale").forGetter(WheelPos::scale), (App)Codec.FLOAT.fieldOf("yaw").forGetter(WheelPos::yaw), (App)WheelEnd.CODEC.fieldOf("end").forGetter(WheelPos::end), (App)WheelSide.CODEC.fieldOf("side").forGetter(WheelPos::side)).apply((Applicative)inst, WheelPos::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WheelPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, WheelPos::forward, (StreamCodec)ByteBufCodecs.FLOAT, WheelPos::right, (StreamCodec)ByteBufCodecs.FLOAT, WheelPos::scale, (StreamCodec)ByteBufCodecs.FLOAT, WheelPos::yaw, (StreamCodec)ByteBufCodecs.INT, p -> p.end().ordinal(), (StreamCodec)ByteBufCodecs.INT, p -> p.side().ordinal(), (a, b, c, d, e, f) -> new WheelPos(a.floatValue(), b.floatValue(), c.floatValue(), d.floatValue(), WheelEnd.values()[e], WheelSide.values()[f]));
    }

    public static enum WheelEnd implements StringRepresentable
    {
        FRONT,
        BACK,
        NONE;

        public static final Codec<WheelEnd> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(WheelEnd::values);
        }
    }

    public static enum WheelSide implements StringRepresentable
    {
        LEFT,
        RIGHT;

        public static final Codec<WheelSide> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(WheelSide::values);
        }
    }
}

